/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Anchor;
import com.megacrit.cardcrawl.relics.AncientTeaSet;
import com.megacrit.cardcrawl.relics.ArtOfWar;
import com.megacrit.cardcrawl.relics.Astrolabe;
import com.megacrit.cardcrawl.relics.BagOfMarbles;
import com.megacrit.cardcrawl.relics.BagOfPreparation;
import com.megacrit.cardcrawl.relics.BirdFacedUrn;
import com.megacrit.cardcrawl.relics.BlackBlood;
import com.megacrit.cardcrawl.relics.BlackStar;
import com.megacrit.cardcrawl.relics.BloodVial;
import com.megacrit.cardcrawl.relics.BloodyIdol;
import com.megacrit.cardcrawl.relics.BlueCandle;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.BottledTornado;
import com.megacrit.cardcrawl.relics.BronzeScales;
import com.megacrit.cardcrawl.relics.BurningBlood;
import com.megacrit.cardcrawl.relics.Calipers;
import com.megacrit.cardcrawl.relics.CallingBell;
import com.megacrit.cardcrawl.relics.Cauldron;
import com.megacrit.cardcrawl.relics.CentennialPuzzle;
import com.megacrit.cardcrawl.relics.ChampionsBelt;
import com.megacrit.cardcrawl.relics.CharonsAshes;
import com.megacrit.cardcrawl.relics.Circlet;
import com.megacrit.cardcrawl.relics.Courier;
import com.megacrit.cardcrawl.relics.CursedKey;
import com.megacrit.cardcrawl.relics.DarkstonePeriapt;
import com.megacrit.cardcrawl.relics.DeadBranch;
import com.megacrit.cardcrawl.relics.Dodecahedron;
import com.megacrit.cardcrawl.relics.DreamCatcher;
import com.megacrit.cardcrawl.relics.DuVuDoll;
import com.megacrit.cardcrawl.relics.Ectoplasm;
import com.megacrit.cardcrawl.relics.Enchiridion;
import com.megacrit.cardcrawl.relics.EternalFeather;
import com.megacrit.cardcrawl.relics.FrozenEgg;
import com.megacrit.cardcrawl.relics.FrozenEye;
import com.megacrit.cardcrawl.relics.GamblingChip;
import com.megacrit.cardcrawl.relics.Ginger;
import com.megacrit.cardcrawl.relics.Girya;
import com.megacrit.cardcrawl.relics.GoldenIdol;
import com.megacrit.cardcrawl.relics.GremlinHorn;
import com.megacrit.cardcrawl.relics.HappyFlower;
import com.megacrit.cardcrawl.relics.IceCream;
import com.megacrit.cardcrawl.relics.JuzuBracelet;
import com.megacrit.cardcrawl.relics.Kunai;
import com.megacrit.cardcrawl.relics.Lantern;
import com.megacrit.cardcrawl.relics.LetterOpener;
import com.megacrit.cardcrawl.relics.LizardTail;
import com.megacrit.cardcrawl.relics.MagicFlower;
import com.megacrit.cardcrawl.relics.Mango;
import com.megacrit.cardcrawl.relics.MarkOfPain;
import com.megacrit.cardcrawl.relics.Matryoshka;
import com.megacrit.cardcrawl.relics.MeatOnTheBone;
import com.megacrit.cardcrawl.relics.MedicalKit;
import com.megacrit.cardcrawl.relics.MembershipCard;
import com.megacrit.cardcrawl.relics.MercuryHourglass;
import com.megacrit.cardcrawl.relics.MoltenEgg;
import com.megacrit.cardcrawl.relics.MummifiedHand;
import com.megacrit.cardcrawl.relics.Necronomicon;
import com.megacrit.cardcrawl.relics.NeowsLament;
import com.megacrit.cardcrawl.relics.NilrysCodex;
import com.megacrit.cardcrawl.relics.NinjaScroll;
import com.megacrit.cardcrawl.relics.NlothsGift;
import com.megacrit.cardcrawl.relics.OddMushroom;
import com.megacrit.cardcrawl.relics.OddlySmoothStone;
import com.megacrit.cardcrawl.relics.OldCoin;
import com.megacrit.cardcrawl.relics.Omamori;
import com.megacrit.cardcrawl.relics.Orichalcum;
import com.megacrit.cardcrawl.relics.OrnamentalFan;
import com.megacrit.cardcrawl.relics.Orrery;
import com.megacrit.cardcrawl.relics.PandorasBox;
import com.megacrit.cardcrawl.relics.Pantograph;
import com.megacrit.cardcrawl.relics.PaperCrane;
import com.megacrit.cardcrawl.relics.PaperFrog;
import com.megacrit.cardcrawl.relics.PeacePipe;
import com.megacrit.cardcrawl.relics.Pear;
import com.megacrit.cardcrawl.relics.PenNib;
import com.megacrit.cardcrawl.relics.PhilosopherStone;
import com.megacrit.cardcrawl.relics.PrayerWheel;
import com.megacrit.cardcrawl.relics.QuestionCard;
import com.megacrit.cardcrawl.relics.RedMask;
import com.megacrit.cardcrawl.relics.RedSkull;
import com.megacrit.cardcrawl.relics.RegalPillow;
import com.megacrit.cardcrawl.relics.RunicCube;
import com.megacrit.cardcrawl.relics.RunicDome;
import com.megacrit.cardcrawl.relics.RunicPyramid;
import com.megacrit.cardcrawl.relics.SelfFormingClay;
import com.megacrit.cardcrawl.relics.Shovel;
import com.megacrit.cardcrawl.relics.Shuriken;
import com.megacrit.cardcrawl.relics.SingingBowl;
import com.megacrit.cardcrawl.relics.SmilingMask;
import com.megacrit.cardcrawl.relics.SnakeRing;
import com.megacrit.cardcrawl.relics.SneckoEye;
import com.megacrit.cardcrawl.relics.SneckoSkull;
import com.megacrit.cardcrawl.relics.Sozu;
import com.megacrit.cardcrawl.relics.SpiritPoop;
import com.megacrit.cardcrawl.relics.StrangeSpoon;
import com.megacrit.cardcrawl.relics.Strawberry;
import com.megacrit.cardcrawl.relics.Sundial;
import com.megacrit.cardcrawl.relics.TheSpecimen;
import com.megacrit.cardcrawl.relics.ThreadAndNeedle;
import com.megacrit.cardcrawl.relics.Tingsha;
import com.megacrit.cardcrawl.relics.TinyChest;
import com.megacrit.cardcrawl.relics.TinyHouse;
import com.megacrit.cardcrawl.relics.Toolbox;
import com.megacrit.cardcrawl.relics.Torii;
import com.megacrit.cardcrawl.relics.ToughBandages;
import com.megacrit.cardcrawl.relics.ToxicEgg;
import com.megacrit.cardcrawl.relics.ToyOrnithopter;
import com.megacrit.cardcrawl.relics.UnceasingTop;
import com.megacrit.cardcrawl.relics.Vajra;
import com.megacrit.cardcrawl.relics.VelvetChoker;
import com.megacrit.cardcrawl.relics.Waffle;
import com.megacrit.cardcrawl.relics.WarPaint;
import com.megacrit.cardcrawl.relics.Whetstone;
import com.megacrit.cardcrawl.relics.WhiteBeast;
import com.megacrit.cardcrawl.relics.deprecated.DerpRock;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelicLibrary {
    private static final Logger logger = LogManager.getLogger(RelicLibrary.class.getName());
    public static int totalRelicCount = 0;
    private static HashMap<String, AbstractRelic> sharedRelics = new HashMap();
    private static HashMap<String, AbstractRelic> redRelics = new HashMap();
    private static HashMap<String, AbstractRelic> greenRelics = new HashMap();
    private static HashMap<String, AbstractRelic> blueRelics = new HashMap();
    public static ArrayList<AbstractRelic> starterList = new ArrayList();
    public static ArrayList<AbstractRelic> commonList = new ArrayList();
    public static ArrayList<AbstractRelic> uncommonList = new ArrayList();
    public static ArrayList<AbstractRelic> rareList = new ArrayList();
    public static ArrayList<AbstractRelic> bossList = new ArrayList();
    public static ArrayList<AbstractRelic> specialList = new ArrayList();
    public static ArrayList<AbstractRelic> shopList = new ArrayList();
    public static ArrayList<AbstractRelic> redList = new ArrayList();
    public static ArrayList<AbstractRelic> greenList = new ArrayList();
    public static ArrayList<AbstractRelic> blueList = new ArrayList();

    public static void initialize() {
        long startTime = System.currentTimeMillis();
        RelicLibrary.add(new Anchor());
        RelicLibrary.add(new ArtOfWar());
        RelicLibrary.add(new Astrolabe());
        RelicLibrary.add(new BagOfMarbles());
        RelicLibrary.add(new BagOfPreparation());
        RelicLibrary.add(new BirdFacedUrn());
        RelicLibrary.add(new BlackStar());
        RelicLibrary.add(new BloodVial());
        RelicLibrary.add(new BloodyIdol());
        RelicLibrary.add(new BlueCandle());
        RelicLibrary.add(new BottledFlame());
        RelicLibrary.add(new BottledLightning());
        if (Settings.isBeta) {
            RelicLibrary.add(new BottledTornado());
        }
        RelicLibrary.add(new BronzeScales());
        RelicLibrary.add(new Calipers());
        RelicLibrary.add(new CallingBell());
        RelicLibrary.add(new Cauldron());
        RelicLibrary.add(new CentennialPuzzle());
        RelicLibrary.add(new Courier());
        RelicLibrary.add(new CursedKey(null));
        RelicLibrary.add(new DarkstonePeriapt());
        RelicLibrary.add(new DeadBranch());
        RelicLibrary.add(new Dodecahedron(null));
        RelicLibrary.add(new DreamCatcher());
        RelicLibrary.add(new DuVuDoll());
        RelicLibrary.add(new Ectoplasm());
        RelicLibrary.add(new Enchiridion());
        RelicLibrary.add(new EternalFeather());
        RelicLibrary.add(new FrozenEgg());
        RelicLibrary.add(new FrozenEye());
        RelicLibrary.add(new GamblingChip());
        RelicLibrary.add(new Ginger());
        RelicLibrary.add(new Girya());
        RelicLibrary.add(new GoldenIdol());
        RelicLibrary.add(new GremlinHorn(null));
        RelicLibrary.add(new HappyFlower());
        RelicLibrary.add(new IceCream());
        RelicLibrary.add(new JuzuBracelet());
        RelicLibrary.add(new Kunai());
        RelicLibrary.add(new Lantern());
        RelicLibrary.add(new LetterOpener());
        RelicLibrary.add(new LizardTail());
        RelicLibrary.add(new Mango());
        RelicLibrary.add(new Matryoshka());
        RelicLibrary.add(new MeatOnTheBone());
        RelicLibrary.add(new MedicalKit());
        RelicLibrary.add(new MembershipCard());
        RelicLibrary.add(new MercuryHourglass());
        RelicLibrary.add(new MoltenEgg());
        RelicLibrary.add(new MummifiedHand());
        RelicLibrary.add(new NeowsLament());
        RelicLibrary.add(new Necronomicon());
        RelicLibrary.add(new NilrysCodex());
        RelicLibrary.add(new NlothsGift());
        RelicLibrary.add(new OddlySmoothStone());
        RelicLibrary.add(new OddMushroom());
        RelicLibrary.add(new OldCoin());
        RelicLibrary.add(new Omamori());
        RelicLibrary.add(new Orichalcum());
        RelicLibrary.add(new OrnamentalFan());
        RelicLibrary.add(new Orrery());
        RelicLibrary.add(new PandorasBox());
        RelicLibrary.add(new Pantograph());
        RelicLibrary.add(new PeacePipe());
        RelicLibrary.add(new Pear());
        RelicLibrary.add(new PenNib());
        RelicLibrary.add(new PhilosopherStone());
        RelicLibrary.add(new PrayerWheel());
        RelicLibrary.add(new QuestionCard());
        RelicLibrary.add(new RedMask());
        RelicLibrary.add(new RegalPillow());
        RelicLibrary.add(new RunicDome(null));
        RelicLibrary.add(new RunicPyramid());
        RelicLibrary.add(new Shovel());
        RelicLibrary.add(new Shuriken());
        RelicLibrary.add(new SingingBowl());
        RelicLibrary.add(new SmilingMask());
        RelicLibrary.add(new SneckoEye());
        RelicLibrary.add(new Sozu());
        RelicLibrary.add(new SpiritPoop());
        RelicLibrary.add(new StrangeSpoon());
        RelicLibrary.add(new Strawberry());
        RelicLibrary.add(new Sundial());
        RelicLibrary.add(new AncientTeaSet());
        RelicLibrary.add(new ThreadAndNeedle());
        RelicLibrary.add(new TinyChest());
        RelicLibrary.add(new TinyHouse());
        RelicLibrary.add(new Toolbox());
        RelicLibrary.add(new Torii());
        RelicLibrary.add(new ToxicEgg());
        RelicLibrary.add(new ToyOrnithopter());
        RelicLibrary.add(new UnceasingTop());
        RelicLibrary.add(new Vajra());
        RelicLibrary.add(new VelvetChoker());
        RelicLibrary.add(new Waffle());
        RelicLibrary.add(new WarPaint());
        RelicLibrary.add(new Whetstone());
        RelicLibrary.add(new WhiteBeast());
        RelicLibrary.addGreen(new NinjaScroll());
        RelicLibrary.addGreen(new PaperCrane());
        RelicLibrary.addGreen(new SnakeRing());
        RelicLibrary.addGreen(new SneckoSkull());
        RelicLibrary.addGreen(new TheSpecimen());
        RelicLibrary.addGreen(new Tingsha());
        RelicLibrary.addGreen(new ToughBandages());
        RelicLibrary.addRed(new BlackBlood());
        RelicLibrary.addRed(new BurningBlood());
        RelicLibrary.addRed(new ChampionsBelt());
        RelicLibrary.addRed(new CharonsAshes());
        RelicLibrary.addRed(new MagicFlower());
        RelicLibrary.addRed(new MarkOfPain());
        RelicLibrary.addRed(new PaperFrog());
        RelicLibrary.addRed(new RedSkull());
        RelicLibrary.addRed(new RunicCube());
        RelicLibrary.addRed(new SelfFormingClay());
        if (Settings.isDev) {
            RelicLibrary.addBlue(new DerpRock());
        }
        if (Settings.isBeta) {
            // empty if block
        }
        logger.info("Relic load time: " + (System.currentTimeMillis() - startTime) + "ms");
        RelicLibrary.sortLists();
        RelicLibrary.printRelicCount();
    }

    private static void sortLists() {
        Collections.sort(starterList);
        Collections.sort(commonList);
        Collections.sort(uncommonList);
        Collections.sort(rareList);
        Collections.sort(bossList);
        Collections.sort(specialList);
        Collections.sort(shopList);
        logger.info(starterList);
        logger.info(commonList);
        logger.info(uncommonList);
        logger.info(rareList);
        logger.info(bossList);
    }

    private static void printRelicCount() {
        int common = 0;
        int uncommon = 0;
        int rare = 0;
        int boss = 0;
        int shop = 0;
        int other = 0;
        block7: for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            switch (r.getValue().tier) {
                case COMMON: {
                    ++common;
                    continue block7;
                }
                case UNCOMMON: {
                    ++uncommon;
                    continue block7;
                }
                case RARE: {
                    ++rare;
                    continue block7;
                }
                case BOSS: {
                    ++boss;
                    continue block7;
                }
                case SHOP: {
                    ++shop;
                    continue block7;
                }
            }
            ++other;
        }
        logger.info(common + "/25 (Common)");
        logger.info(uncommon + "/25 (Uncommon)");
        logger.info(rare + "/20 (Rare)");
        logger.info(boss + "/20 (Boss)");
        logger.info(shop + "/5 (Shop)");
        logger.info(other + "/? (Other)");
        logger.info(redRelics.size() + "/8 (Red)");
        logger.info(greenRelics.size() + "/8 (Green)");
        logger.info(blueRelics.size() + "/8 (Blue)");
    }

    public static void add(AbstractRelic relic) {
        relic.isSeen = UnlockTracker.isRelicSeen(relic.relicId);
        sharedRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        ++totalRelicCount;
    }

    public static void addRed(AbstractRelic relic) {
        relic.isSeen = UnlockTracker.isRelicSeen(relic.relicId);
        redRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        redList.add(relic);
        ++totalRelicCount;
    }

    public static void addGreen(AbstractRelic relic) {
        relic.isSeen = UnlockTracker.isRelicSeen(relic.relicId);
        greenRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        greenList.add(relic);
        ++totalRelicCount;
    }

    public static void addBlue(AbstractRelic relic) {
        relic.isSeen = UnlockTracker.isRelicSeen(relic.relicId);
        blueRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        blueList.add(relic);
        ++totalRelicCount;
    }

    public static void addToTierList(AbstractRelic relic) {
        switch (relic.tier) {
            case STARTER: {
                starterList.add(relic);
                break;
            }
            case COMMON: {
                commonList.add(relic);
                break;
            }
            case UNCOMMON: {
                uncommonList.add(relic);
                break;
            }
            case RARE: {
                rareList.add(relic);
                break;
            }
            case SHOP: {
                shopList.add(relic);
                break;
            }
            case SPECIAL: {
                specialList.add(relic);
                break;
            }
            case BOSS: {
                bossList.add(relic);
                break;
            }
            case DEPRECATED: {
                logger.info(relic.relicId + " is deprecated.");
                break;
            }
            default: {
                logger.info(relic.relicId + " is undefined tier.");
            }
        }
    }

    public static AbstractRelic getRelic(String key) {
        if (sharedRelics.containsKey(key)) {
            return sharedRelics.get(key);
        }
        if (redRelics.containsKey(key)) {
            return redRelics.get(key);
        }
        if (greenRelics.containsKey(key)) {
            return greenRelics.get(key);
        }
        if (blueRelics.containsKey(key)) {
            return blueRelics.get(key);
        }
        return new Circlet();
    }

    public static void populateRelicPool(ArrayList<String> pool, AbstractRelic.RelicTier tier, AbstractPlayer.PlayerClass c) {
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            if (r.getValue().tier != tier || UnlockTracker.isRelicLocked(r.getKey()) && !Settings.isDailyRun) continue;
            pool.add(r.getKey());
        }
        switch (c) {
            case IRONCLAD: {
                for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked(r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
            case THE_SILENT: {
                for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked(r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
            case CROWBOT: {
                for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked(r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
        }
    }

    public static void addSharedRelics(ArrayList<AbstractRelic> relicPool) {
        logger.info("[RELIC] Adding " + sharedRelics.size() + " shared relics...");
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            relicPool.add(r.getValue());
        }
    }

    public static void addClassSpecificRelics(ArrayList<AbstractRelic> relicPool) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                logger.info("[RELIC] Adding " + redRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
            case THE_SILENT: {
                logger.info("[RELIC] Adding " + greenRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
            case CROWBOT: {
                logger.info("[RELIC] Adding " + blueRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
        }
    }

    public static void uploadRelicData() {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("All"));
        }
        for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Red"));
        }
        for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Green"));
        }
        for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Blue"));
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.RELIC_DATA, "", AbstractRelic.debugDetailedRelicDataHeader(), data, false);
        Thread t = new Thread(poster);
        t.run();
    }

    public static ArrayList<AbstractRelic> sortByName(ArrayList<AbstractRelic> group, boolean ascending) {
        ArrayList<AbstractRelic> tmp = new ArrayList<AbstractRelic>();
        for (AbstractRelic r : group) {
            int addIndex = 0;
            for (AbstractRelic r2 : tmp) {
                if (!ascending ? r.name.compareTo(r2.name) < 0 : r.name.compareTo(r2.name) > 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, r);
        }
        return tmp;
    }

    public static ArrayList<AbstractRelic> sortByStatus(ArrayList<AbstractRelic> group, boolean ascending) {
        ArrayList<AbstractRelic> tmp = new ArrayList<AbstractRelic>();
        for (AbstractRelic r : group) {
            int addIndex = 0;
            for (AbstractRelic r2 : tmp) {
                String b;
                String a;
                if (!ascending ? (a = UnlockTracker.isRelicLocked(r.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen(r.relicId) ? "UNSEEN" : "SEEN")).compareTo(b = UnlockTracker.isRelicLocked(r2.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen(r2.relicId) ? "UNSEEN" : "SEEN")) > 0 : (a = UnlockTracker.isRelicLocked(r.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen(r.relicId) ? "UNSEEN" : "SEEN")).compareTo(b = UnlockTracker.isRelicLocked(r2.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen(r2.relicId) ? "UNSEEN" : "SEEN")) < 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, r);
        }
        return tmp;
    }

    public static void unlockAndSeeAllRelics() {
        for (String string : UnlockTracker.lockedRelics) {
            UnlockTracker.hardUnlockOverride(string);
        }
        for (Map.Entry entry : sharedRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)entry.getKey());
        }
        for (Map.Entry entry : redRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)entry.getKey());
        }
        for (Map.Entry entry : greenRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)entry.getKey());
        }
        for (Map.Entry entry : blueRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)entry.getKey());
        }
    }
}

